/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.paginas;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.RaizModelo;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.editores.EditorBase;
import ec.gob.sri.dimm.api.ui.paginas.PaginaBase;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.ComprobanteAnulado;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.ui.ConstantesUI;
import ec.gob.sri.dimm.ats.ui.dialogos.DialogoComprobanteAnulado;
import ec.gob.sri.dimm.ats.ui.dialogos.filtros.ComprobantesAnuladosFilter;
import ec.gob.sri.dimm.ats.ui.editores.EditorATS;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wb.swt.ResourceManager;
import swing2swt.layout.BorderLayout;

public class PaginaAnulados
extends PaginaBase<EditorATS>
implements VistaModelo<Iva> {
    private DataBindingContext m_bindingContext;
    private Iva modeloDatos;
    private Table table;
    private ToolItem tltmNuevo;
    private Text txtNumAutorizacion;
    private Button btnBtnbuscar;
    private ToolItem tltmEditar;
    private ToolItem tltmEliminar;
    private ComprobantesAnuladosFilter filtroComprobantes;
    private Label lblRegistros;
    private ComprobanteAnulado comprobanteSeleccionado;
    private TableViewer tvComprobantes;

    public PaginaAnulados(EditorATS editor, String id, String title) {
        super((EditorBase)editor, id, title);
    }

    public void setModeloDatos(Iva modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public void procesarModeloDatos() {
    }

    protected void createFormContent(IManagedForm managedForm) {
        managedForm.getForm().setDelayedReflow(true);
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        toolkit.paintBordersFor(body);
        managedForm.getForm().getBody().setLayout((Layout)new ColumnLayout());
        Section sctnComprobantesAnulados = managedForm.getToolkit().createSection(managedForm.getForm().getBody(), 256);
        managedForm.getToolkit().paintBordersFor((Composite)sctnComprobantesAnulados);
        sctnComprobantesAnulados.setText("Comprobantes Anulados");
        Composite composite = managedForm.getToolkit().createComposite((Composite)sctnComprobantesAnulados, 0);
        managedForm.getToolkit().paintBordersFor(composite);
        sctnComprobantesAnulados.setClient((Control)composite);
        composite.setLayout((Layout)new RowLayout(256));
        Composite cAnulados = managedForm.getToolkit().createComposite(composite, 0);
        cAnulados.setLayout((Layout)new BorderLayout(0, 0));
        cAnulados.setLayoutData((Object)new RowData(-1, 360));
        managedForm.getToolkit().paintBordersFor(cAnulados);
        this.tvComprobantes = new TableViewer(cAnulados, 67584);
        this.table = this.tvComprobantes.getTable();
        this.filtroComprobantes = new ComprobantesAnuladosFilter();
        this.filtroComprobantes.setSearchText("");
        this.tvComprobantes.addFilter((ViewerFilter)this.filtroComprobantes);
        this.tvComprobantes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                PaginaAnulados.this.comprobanteSeleccionado = (ComprobanteAnulado)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
            }
        });
        this.table.setHeaderVisible(true);
        managedForm.getToolkit().paintBordersFor((Composite)this.table);
        TableColumn tblclmnTipoDeComprobante = new TableColumn(this.table, 0);
        tblclmnTipoDeComprobante.setWidth(250);
        tblclmnTipoDeComprobante.setText("Tipo de Comprobante");
        TableColumn tblclmnSerial = new TableColumn(this.table, 0);
        tblclmnSerial.setWidth(100);
        tblclmnSerial.setText("Serial ");
        TableColumn tblclmnSecuencialDesde = new TableColumn(this.table, 0);
        tblclmnSecuencialDesde.setWidth(120);
        tblclmnSecuencialDesde.setText("Secuencial Desde");
        TableColumn tblclmnSecuencialhasta = new TableColumn(this.table, 0);
        tblclmnSecuencialhasta.setWidth(120);
        tblclmnSecuencialhasta.setText("Secuencial Hasta");
        TableColumn tblclmnAutorizacin = new TableColumn(this.table, 0);
        tblclmnAutorizacin.setWidth(100);
        tblclmnAutorizacin.setText("Autorizaci\u00f3n");
        Composite cCabecera = managedForm.getToolkit().createComposite(cAnulados, 0);
        cCabecera.setLayoutData((Object)"North");
        managedForm.getToolkit().paintBordersFor(cCabecera);
        GridLayout gl_cCabecera = new GridLayout(4, false);
        gl_cCabecera.verticalSpacing = 1;
        cCabecera.setLayout((Layout)gl_cCabecera);
        ToolBar toolBar = new ToolBar(cCabecera, 0x820000);
        GridData gd_toolBar = new GridData(16384, 4, false, false, 1, 1);
        gd_toolBar.widthHint = 390;
        toolBar.setLayoutData((Object)gd_toolBar);
        managedForm.getToolkit().adapt((Composite)toolBar);
        managedForm.getToolkit().paintBordersFor((Composite)toolBar);
        this.tltmNuevo = new ToolItem(toolBar, 0);
        this.tltmNuevo.setText("Nuevo");
        this.tltmEditar = new ToolItem(toolBar, 0);
        this.tltmEditar.setText("Editar");
        this.tltmEliminar = new ToolItem(toolBar, 0);
        this.tltmEliminar.setText("Eliminar");
        Label lblNewLabel = new Label(cCabecera, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        managedForm.getToolkit().adapt((Control)lblNewLabel, true, true);
        lblNewLabel.setText("Filtrar por Autorizaci\u00f3n:");
        this.txtNumAutorizacion = new Text(cCabecera, 2048);
        GridData gd_txtNumAutorizacion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtNumAutorizacion.widthHint = 114;
        this.txtNumAutorizacion.setLayoutData((Object)gd_txtNumAutorizacion);
        this.txtNumAutorizacion.setBounds(0, 0, 76, 21);
        managedForm.getToolkit().adapt((Control)this.txtNumAutorizacion, true, true);
        this.btnBtnbuscar = new Button(cCabecera, 0);
        this.btnBtnbuscar.setImage(ResourceManager.getPluginImage((String)"ec.gob.sri.dimm.ats.ui", (String)"iconos/search.png"));
        managedForm.getToolkit().adapt((Control)this.btnBtnbuscar, true, true);
        Composite cRegistros = new Composite(cAnulados, 0);
        cRegistros.setLayoutData((Object)"South");
        managedForm.getToolkit().adapt(cRegistros);
        managedForm.getToolkit().paintBordersFor(cRegistros);
        cRegistros.setLayout((Layout)new GridLayout(1, false));
        this.lblRegistros = new Label(cRegistros, 0);
        GridData gd_lblRegistros = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblRegistros.widthHint = 500;
        this.lblRegistros.setLayoutData((Object)gd_lblRegistros);
        managedForm.getToolkit().adapt((Control)this.lblRegistros, true, true);
        this.m_bindingContext = this.initDataBindings();
        this.btnNuevoClicked();
        this.btnEditarClicked();
        this.btnEliminarClicked();
        this.btnBuscarClicked();
    }

    private void btnNuevoClicked() {
        this.tltmNuevo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComprobanteAnulado comprobante = new ComprobanteAnulado();
                if (PaginaAnulados.this.abrirDialogoAnulado(comprobante)) {
                    PaginaAnulados.this.modeloDatos.agregarComprobanteAnulado(comprobante);
                    ((EditorATS)PaginaAnulados.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaAnulados.this.modeloDatos);
                    PaginaAnulados.this.generarAlertaFiltro(PaginaAnulados.this.txtNumAutorizacion.getText());
                }
            }
        });
    }

    private void btnEditarClicked() {
        this.tltmEditar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComprobanteAnulado copiaEdicion;
                if (PaginaAnulados.this.comprobanteSeleccionado != null && PaginaAnulados.this.abrirDialogoAnulado(copiaEdicion = PaginaAnulados.this.comprobanteSeleccionado.crearCopiaEdicion())) {
                    PaginaAnulados.this.comprobanteSeleccionado.actualizarInformacion(copiaEdicion);
                    PaginaAnulados.this.tvComprobantes.refresh();
                    ((EditorATS)PaginaAnulados.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaAnulados.this.modeloDatos);
                }
            }
        });
    }

    private void btnEliminarClicked() {
        this.tltmEliminar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaAnulados.this.comprobanteSeleccionado != null && PaginaAnulados.this.mostrarConfirmacion("\u00bfEst\u00e1 seguro de que desea eliminar el comprobante seleccionado?") && PaginaAnulados.this.modeloDatos.eliminarComprobanteAnulado(PaginaAnulados.this.comprobanteSeleccionado)) {
                    PaginaAnulados.this.comprobanteSeleccionado = null;
                    ((EditorATS)PaginaAnulados.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaAnulados.this.modeloDatos);
                    PaginaAnulados.this.generarAlertaFiltro(PaginaAnulados.this.txtNumAutorizacion.getText());
                }
            }
        });
    }

    private void btnBuscarClicked() {
        this.btnBtnbuscar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaginaAnulados.this.filtroComprobantes.setSearchText(PaginaAnulados.this.txtNumAutorizacion.getText());
                PaginaAnulados.this.tvComprobantes.refresh();
                PaginaAnulados.this.generarAlertaFiltro(PaginaAnulados.this.txtNumAutorizacion.getText());
            }
        });
    }

    private boolean abrirDialogoAnulado(ComprobanteAnulado modeloDialogo) {
        DialogoComprobanteAnulado dialogo = new DialogoComprobanteAnulado(this.getSite(), this.modeloDatos.getComprobantesAnulados(), this.modeloDatos.periodo);
        dialogo.setModeloDatos(modeloDialogo);
        dialogo.inicializarModeloValores();
        return dialogo.open() == 0;
    }

    private void generarAlertaFiltro(String textoFiltro) {
        if (StringUtil.isNullOrEmpty((String)textoFiltro)) {
            this.lblRegistros.setForeground(ConstantesUI.COLOR_FOREGROUND);
            this.lblRegistros.setText(String.format("Total Registros: %d %s", this.modeloDatos.getComprobantesAnulados().size(), "Comprobante(s) Anulado(s)"));
        } else {
            this.lblRegistros.setForeground(ConstantesUI.COLOR_FILTRO);
            this.lblRegistros.setText(String.format("N\u00famero de registros filtrados: %d, de un total de %d %s", this.tvComprobantes.getTable().getItemCount(), this.modeloDatos.getComprobantesAnulados().size(), "Comprobante(s) Anulado(s)"));
        }
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap[] observeMaps = BeansObservables.observeMaps((IObservableSet)listContentProvider.getKnownElements(), ComprobanteAnulado.class, (String[])new String[]{"descripcionTipoComprobanteAnulado", "serial", "secuencialDesde", "secuencialHasta", "numAutorizacion"});
        this.tvComprobantes.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps));
        this.tvComprobantes.setContentProvider((IContentProvider)listContentProvider);
        IObservableList comprobantesAnuladosModeloDatosObserveList = BeanProperties.list((String)"comprobantesAnulados").observe((Object)this.modeloDatos);
        this.tvComprobantes.setInput((Object)comprobantesAnuladosModeloDatosObserveList);
        this.generarAlertaFiltro(null);
        return bindingContext;
    }
}

